/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lane;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.io.Serializable;

public class ActionLaneLec
implements StatusMapper,
TableStatusNamer {
    private static String enumBundle = "ibm.nways.lane.eui.EnumeratedResources";
    private static String laneBundle = "ibm.nways.lane.Resources";
    private boolean loggingOn = false;

    public ActionLaneLec() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        if (this.loggingOn) {
            System.out.println("ActionLaneLec");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        int n = (Integer)serializableArray[0];
        if (this.loggingOn) {
            System.out.println("Lec InterfaceState = " + statusModelInfo.get("Panel.LecInterfaceState") + n);
        }
        Integer n2 = (Integer)statusModelInfo.get("Panel.LecInterfaceState");
        int n3 = n2;
        StatusAndExplain statusAndExplain = this.evaluateLecInterfaceState(n3, n);
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionLec - nameThatObject");
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(laneBundle, "STATUS_NAME_LEC", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionLec - nameThatTableObject");
        }
        I18NString i18NString = new I18NString(laneBundle, "STATUS_TABLE_LEC");
        return i18NString;
    }

    private StatusAndExplain evaluateLecInterfaceState(int n, int n2) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[]{new Integer(n2)};
        objectArray[0] = new I18NMsgFormat(laneBundle, "lecstatus", objectArray2);
        switch (n) {
            case 1: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.LecModel.Panel.LecLastFailureState.initialState");
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.LecModel.Panel.LecLastFailureState.lecsConnect");
                break;
            }
            case 3: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.LecModel.Panel.LecLastFailureState.configure");
                break;
            }
            case 4: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.LecModel.Panel.LecLastFailureState.join");
                break;
            }
            case 5: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.LecModel.Panel.LecLastFailureState.initialRegistration");
                break;
            }
            case 6: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.LecModel.Panel.LecLastFailureState.busConnect");
                break;
            }
            case 7: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.LecModel.Panel.LecLastFailureState.operational");
                break;
            }
            default: {
                objectArray[1] = new I18NString(enumBundle, "unknown");
                statusAndExplain.statType = StatusType.UNKNOWN;
            }
        }
        statusAndExplain.explain = new I18NGiblets(laneBundle, "statusorder", objectArray);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionLaneLec.this = ActionLaneLec.this;
        }
    }
}

